/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.core.inferencing;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.index.core.Index;
import com.aptana.js.core.JSCorePlugin;
import com.aptana.js.core.JSTypeConstants;
import com.aptana.js.core.index.JSIndexQueryHelper;
import com.aptana.js.core.inferencing.CommonJSResolver;
import com.aptana.js.core.inferencing.IAliasResolver;
import com.aptana.js.core.inferencing.JSPropertyCollection;
import com.aptana.js.core.inferencing.JSScope;
import com.aptana.js.core.inferencing.JSTypeMapper;
import com.aptana.js.core.inferencing.JSTypeUtil;
import com.aptana.js.core.inferencing.RequireResolverFactory;
import com.aptana.js.core.model.FunctionElement;
import com.aptana.js.core.model.PropertyElement;
import com.aptana.js.core.parsing.JSTokenType;
import com.aptana.js.core.parsing.ast.JSArgumentsNode;
import com.aptana.js.core.parsing.ast.JSArrayNode;
import com.aptana.js.core.parsing.ast.JSAssignmentNode;
import com.aptana.js.core.parsing.ast.JSBinaryArithmeticOperatorNode;
import com.aptana.js.core.parsing.ast.JSBinaryBooleanOperatorNode;
import com.aptana.js.core.parsing.ast.JSConditionalNode;
import com.aptana.js.core.parsing.ast.JSConstructNode;
import com.aptana.js.core.parsing.ast.JSFalseNode;
import com.aptana.js.core.parsing.ast.JSFunctionNode;
import com.aptana.js.core.parsing.ast.JSGetElementNode;
import com.aptana.js.core.parsing.ast.JSGetPropertyNode;
import com.aptana.js.core.parsing.ast.JSGroupNode;
import com.aptana.js.core.parsing.ast.JSIdentifierNode;
import com.aptana.js.core.parsing.ast.JSInvokeNode;
import com.aptana.js.core.parsing.ast.JSNode;
import com.aptana.js.core.parsing.ast.JSNumberNode;
import com.aptana.js.core.parsing.ast.JSObjectNode;
import com.aptana.js.core.parsing.ast.JSPostUnaryOperatorNode;
import com.aptana.js.core.parsing.ast.JSPreUnaryOperatorNode;
import com.aptana.js.core.parsing.ast.JSRegexNode;
import com.aptana.js.core.parsing.ast.JSReturnNode;
import com.aptana.js.core.parsing.ast.JSStringNode;
import com.aptana.js.core.parsing.ast.JSTreeWalker;
import com.aptana.js.core.parsing.ast.JSTrueNode;
import com.aptana.js.internal.core.inferencing.JSPropertyCollector;
import com.aptana.js.internal.core.inferencing.JSSymbolTypeInferrer;
import com.aptana.js.internal.core.parsing.sdoc.model.DocumentationBlock;
import com.aptana.js.internal.core.parsing.sdoc.model.ParamTag;
import com.aptana.js.internal.core.parsing.sdoc.model.Tag;
import com.aptana.js.internal.core.parsing.sdoc.model.TagType;
import com.aptana.js.internal.core.parsing.sdoc.model.Type;
import com.aptana.parsing.ast.IParseNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSNodeTypeInferrer
extends JSTreeWalker {
    private JSScope _scope;
    private Index _index;
    private URI _location;
    private List<String> _types;
    private JSIndexQueryHelper _queryHelper;
    private IAliasResolver _factory;
    private IPath _projectLocation;
    private SubMonitor _monitor;

    public JSNodeTypeInferrer(JSScope scope, Index projectIndex, URI location, JSIndexQueryHelper queryHelper) {
        this(scope, projectIndex, location, queryHelper, (IProgressMonitor)new NullProgressMonitor());
    }

    public JSNodeTypeInferrer(JSScope scope, Index projectIndex, URI location, JSIndexQueryHelper queryHelper, IProgressMonitor monitor) {
        this._scope = scope;
        this._index = projectIndex;
        this._location = location;
        this._queryHelper = queryHelper;
        this._monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
        this._factory = JSCorePlugin.getDefault().getAliasResolver();
    }

    private void addParameterTypes(JSIdentifierNode identifierNode) {
        DocumentationBlock docs;
        IParseNode parent = identifierNode.getParent();
        IParseNode grandparent = parent != null ? parent.getParent() : null;
        boolean foundType = false;
        if (grandparent != null && grandparent.getNodeType() == 70 && (docs = ((JSNode)grandparent).getDocumentation()) != null) {
            ParamTag param;
            String name = identifierNode.getText();
            int index = identifierNode.getIndex();
            List<Tag> params = docs.getTags(TagType.PARAM);
            if (params != null && index < params.size() && name.equals((param = (ParamTag)params.get(index)).getName())) {
                for (Type parameterType : param.getTypes()) {
                    String type = parameterType.getName();
                    type = JSTypeMapper.getInstance().getMappedType(type);
                    this.addType(type);
                    foundType = true;
                }
            }
        }
        if (!foundType) {
            this.addType("Object");
        }
    }

    public void addType(String type) {
        if (type != null && type.length() > 0) {
            if (this._types == null) {
                this._types = new ArrayList<String>();
            }
            if (!this._types.contains(type = JSTypeUtil.validateTypeName(type))) {
                this._types.add(type);
            }
        }
    }

    protected void addTypes(IParseNode node) {
        if (node instanceof JSNode) {
            ((JSNode)node).accept(this);
        }
    }

    protected void addTypes(List<String> types) {
        if (types != null) {
            for (String type : types) {
                this.addType(type);
            }
        }
    }

    protected JSScope getActiveScope(int offset) {
        JSScope candidate;
        if (this._scope == null) {
            return null;
        }
        JSScope root = this._scope;
        while ((candidate = root.getParentScope()) != null) {
            root = candidate;
        }
        return root.getScopeAtOffset(offset);
    }

    public List<String> getTypes() {
        return CollectionsUtil.getListValue(this._types);
    }

    public List<String> getTypes(IParseNode node) {
        return this.getTypes(node, this._scope);
    }

    public List<String> getTypes(IParseNode node, JSScope scope) {
        if (node instanceof JSNode) {
            JSNodeTypeInferrer walker = new JSNodeTypeInferrer(scope, this._index, this._location, this._queryHelper, (IProgressMonitor)this._monitor.newChild(1));
            walker.visit((JSNode)node);
            return walker.getTypes();
        }
        return Collections.emptyList();
    }

    @Override
    public void visit(JSArrayNode node) {
        this.checkCancellation();
        if (!node.hasChildren()) {
            this.addType("Array");
        } else {
            for (String type : this.getTypes(node.getFirstChild())) {
                this.addType(JSTypeUtil.createGenericArrayType(type));
            }
        }
        this._monitor.worked(1);
    }

    private void checkCancellation() {
        if (this._monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    @Override
    public void visit(JSAssignmentNode node) {
        this.checkCancellation();
        switch (node.getNodeType()) {
            case 1: {
                this.addTypes(node.getRightHandSide());
                break;
            }
            case 2: {
                String type = "Number";
                List<String> lhsTypes = this.getTypes(node.getLeftHandSide());
                List<String> rhsTypes = this.getTypes(node.getRightHandSide());
                if (lhsTypes.contains("String") || rhsTypes.contains("String")) {
                    type = "String";
                }
                this.addType(type);
                break;
            }
            default: {
                this.addType("Number");
            }
        }
        this._monitor.worked(1);
    }

    @Override
    public void visit(JSBinaryArithmeticOperatorNode node) {
        this.checkCancellation();
        String type = "Number";
        if (node.getNodeType() == 36) {
            IParseNode lhs = node.getLeftHandSide();
            IParseNode rhs = node.getRightHandSide();
            while (lhs.getNodeType() == 36) {
                rhs = lhs.getLastChild();
                lhs = lhs.getFirstChild();
                if (rhs instanceof JSStringNode) break;
            }
            if (lhs instanceof JSStringNode || rhs instanceof JSStringNode) {
                type = "String";
            } else {
                List<String> lhsTypes = this.getTypes(lhs);
                List<String> rhsTypes = this.getTypes(rhs);
                if (lhsTypes.contains("String") || rhsTypes.contains("String")) {
                    type = "String";
                }
            }
        }
        this.addType(type);
        this._monitor.worked(1);
    }

    @Override
    public void visit(JSBinaryBooleanOperatorNode node) {
        this.checkCancellation();
        JSTokenType token = JSTokenType.get((String)node.getOperator().value);
        switch (token) {
            case AMPERSAND_AMPERSAND: 
            case PIPE_PIPE: {
                this.addTypes(node.getLeftHandSide());
                this.addTypes(node.getRightHandSide());
                break;
            }
            default: {
                this.addType("Boolean");
            }
        }
        this._monitor.worked(1);
    }

    @Override
    public void visit(JSConditionalNode node) {
        this.checkCancellation();
        this.addTypes(node.getTrueExpression());
        this.addTypes(node.getFalseExpression());
        this._monitor.worked(1);
    }

    @Override
    public void visit(JSConstructNode node) {
        this.checkCancellation();
        IParseNode child = node.getExpression();
        if (child instanceof JSNode) {
            List<String> types = this.getTypes(child);
            ArrayList<String> returnTypes = new ArrayList<String>(types.size());
            for (String typeName : types) {
                if (typeName.startsWith("Class<")) {
                    returnTypes.add(JSTypeUtil.getClassType(typeName));
                    continue;
                }
                if (typeName.startsWith("Function<")) {
                    returnTypes.addAll(JSTypeUtil.getFunctionSignatureReturnTypeNames(typeName));
                    continue;
                }
                returnTypes.add(typeName);
            }
            for (String typeName : returnTypes) {
                this.addType(typeName);
            }
        }
        this._monitor.worked(1);
    }

    @Override
    public void visit(JSFalseNode node) {
        this.checkCancellation();
        this.addType("Boolean");
        this._monitor.worked(1);
    }

    @Override
    public void visit(JSFunctionNode node) {
        this.checkCancellation();
        ArrayList<String> types = new ArrayList<String>();
        JSScope scope = this.getActiveScope(node.getBody().getStartingOffset());
        boolean foundReturnExpression = false;
        for (JSReturnNode returnValue : node.getReturnNodes()) {
            IParseNode expression = returnValue.getExpression();
            if (expression.isEmpty()) continue;
            foundReturnExpression = true;
            types.addAll(this.getTypes(expression, scope));
        }
        if (foundReturnExpression && types.isEmpty()) {
            types.add("Object");
        }
        String type = JSTypeUtil.toFunctionType(types);
        this.addType(type);
        this._monitor.worked(1);
    }

    @Override
    public void visit(JSGetElementNode node) {
        this.checkCancellation();
        IParseNode lhs = node.getLeftHandSide();
        if (lhs instanceof JSNode) {
            for (String typeName : this.getTypes(lhs)) {
                String typeString = JSTypeUtil.getArrayElementType(typeName);
                if (typeString != null) {
                    this.addType(typeString);
                    continue;
                }
                this.addType("Object");
            }
        }
        this._monitor.worked(1);
    }

    @Override
    public void visit(JSGetPropertyNode node) {
        this.checkCancellation();
        IParseNode lhs = node.getLeftHandSide();
        if (lhs instanceof JSNode) {
            IParseNode rhs = node.getRightHandSide();
            String memberName = rhs.getText();
            for (String typeName : this.getTypes(lhs)) {
                Collection<PropertyElement> properties;
                typeName = JSTypeMapper.getInstance().getMappedType(typeName);
                if (JSTypeConstants.FUNCTION_JQUERY.equals(typeName) && lhs instanceof JSIdentifierNode && ("$".equals(lhs.getText()) || "jQuery".equals(lhs.getText()))) {
                    typeName = JSTypeConstants.CLASS_JQUERY;
                }
                if ((properties = this._queryHelper.getTypeMembers(typeName, memberName)) == null) continue;
                for (PropertyElement property : properties) {
                    if (property instanceof FunctionElement) {
                        FunctionElement function = (FunctionElement)property;
                        for (String type : function.getSignatureTypes()) {
                            this.addType(type);
                        }
                        continue;
                    }
                    for (String type : property.getTypeNames()) {
                        this.addType(type);
                    }
                }
            }
        }
        this._monitor.worked(1);
    }

    @Override
    public void visit(JSGroupNode node) {
        this.checkCancellation();
        IParseNode expression = node.getExpression();
        if (expression instanceof JSNode) {
            ((JSNode)expression).accept(this);
        }
        this._monitor.worked(1);
    }

    @Override
    public void visit(JSIdentifierNode node) {
        this.checkCancellation();
        String name = node.getText();
        Collection<Object> properties = null;
        if (this._scope != null && this._scope.hasSymbol(name)) {
            IParseNode parent = node.getParent();
            if (parent != null && parent.getNodeType() == 69) {
                this.addParameterTypes(node);
            } else {
                JSSymbolTypeInferrer symbolInferrer = new JSSymbolTypeInferrer(this._scope, this._index, this._location, this._queryHelper);
                PropertyElement property = symbolInferrer.getSymbolPropertyElement(name, (IProgressMonitor)this._monitor.newChild(1));
                properties = property != null ? CollectionsUtil.newList((Object[])new PropertyElement[]{property}) : this._queryHelper.getGlobals(this.getFileName(), name);
            }
        } else {
            if (this._projectLocation == null && this.getProject() != null) {
                this._projectLocation = this.getProject().getLocation();
            }
            if (this._projectLocation != null) {
                name = this._factory.resolve(name, URIUtil.toPath((URI)this._location), this._projectLocation);
            }
            properties = this._queryHelper.getGlobals(this.getFileName(), name);
        }
        if (properties != null) {
            for (PropertyElement property : properties) {
                if (property instanceof FunctionElement) {
                    FunctionElement function = (FunctionElement)property;
                    for (String type : function.getSignatureTypes()) {
                        this.addType(type);
                    }
                    continue;
                }
                for (String type : property.getTypeNames()) {
                    this.addType(type);
                }
            }
        }
        this._monitor.worked(1);
    }

    protected String getFileName() {
        return com.aptana.core.util.URIUtil.getFileName((URI)this._location);
    }

    protected IProject getProject() {
        URI root = this._index.getRoot();
        IPath containerPath = URIUtil.toPath((URI)root);
        if (containerPath == null) {
            return null;
        }
        IContainer container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(containerPath);
        if (container == null) {
            return null;
        }
        return container.getProject();
    }

    @Override
    public void visit(JSInvokeNode node) {
        this.checkCancellation();
        JSNode child = node.getExpression();
        if (child instanceof JSNode) {
            IParseNode parent;
            List<String> types;
            if (child instanceof JSIdentifierNode && "require".equals(child.getNameNode().getName())) {
                JSArgumentsNode args = node.getArguments();
                IParseNode[] children = args.getChildren();
                IParseNode[] iParseNodeArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath absolutePath;
                    String typeName;
                    IParseNode arg = iParseNodeArray[n2];
                    String moduleId = CommonJSResolver.getModuleId(arg);
                    if (!StringUtil.isEmpty((String)moduleId) && (typeName = this._queryHelper.getModuleType(absolutePath = this.resolve(moduleId))) != null) {
                        this.addType(typeName);
                        return;
                    }
                    ++n2;
                }
            }
            if ((types = this.getTypes((IParseNode)child)).isEmpty() && (parent = node.getParent()) != null) {
                switch (parent.getNodeType()) {
                    case 1: {
                        if (node.getIndex() != 1) break;
                        this.addType("Object");
                        break;
                    }
                    case 48: {
                        this.addType("Object");
                        break;
                    }
                }
            }
            for (String typeName : types) {
                if (!JSTypeUtil.isFunctionPrefix(typeName)) continue;
                List<String> returnTypes = JSTypeUtil.getFunctionSignatureReturnTypeNames(typeName);
                for (String returnTypeName : returnTypes) {
                    this.addType(returnTypeName);
                }
            }
        }
        this._monitor.worked(1);
    }

    protected IPath resolve(String moduleId) {
        return RequireResolverFactory.resolve(moduleId, this.getProject(), Path.fromPortableString((String)this._location.getPath()).removeLastSegments(1), Path.fromPortableString((String)this._index.getRoot().getPath()));
    }

    @Override
    public void visit(JSNumberNode node) {
        this.checkCancellation();
        this.addType("Number");
        this._monitor.worked(1);
    }

    @Override
    public void visit(JSObjectNode node) {
        this.checkCancellation();
        if (node.hasChildren()) {
            JSPropertyCollection symbol = new JSPropertyCollection();
            JSPropertyCollector collector = new JSPropertyCollector(symbol);
            collector.visit(node);
            symbol.addValue(node);
            JSSymbolTypeInferrer inferrer = new JSSymbolTypeInferrer(this._scope, this._index, this._location, this._queryHelper);
            LinkedHashSet<String> types = new LinkedHashSet<String>();
            inferrer.processProperties(symbol, types, (IProgressMonitor)this._monitor.newChild(1));
            this.addTypes(new ArrayList<String>(types));
        } else {
            this.addType("Object");
        }
        this._monitor.worked(1);
    }

    @Override
    public void visit(JSPostUnaryOperatorNode node) {
        this.checkCancellation();
        this.addType("Number");
        this._monitor.worked(1);
    }

    @Override
    public void visit(JSPreUnaryOperatorNode node) {
        this.checkCancellation();
        switch (node.getNodeType()) {
            case 49: 
            case 50: {
                this.addType("Boolean");
                break;
            }
            case 56: {
                this.addType("String");
                break;
            }
            case 57: {
                break;
            }
            default: {
                this.addType("Number");
            }
        }
        this._monitor.worked(1);
    }

    @Override
    public void visit(JSRegexNode node) {
        this.checkCancellation();
        this.addType("RegExp");
        this._monitor.worked(1);
    }

    @Override
    public void visit(JSStringNode node) {
        this.checkCancellation();
        this.addType("String");
        this._monitor.worked(1);
    }

    @Override
    public void visit(JSTrueNode node) {
        this.checkCancellation();
        this.addType("Boolean");
        this._monitor.worked(1);
    }
}

